/******************************************************************************
*                                                  
*  (c) copyright Freescale Semiconductor 2010
*  ALL RIGHTS RESERVED
*
*  File Name:   ButtonsHandler.h
*                                                                          
*  Description: Buttons Handler for Activity Monitor
*                                                                                     
*  Assembler:   Codewarrior for HC(S)08 V6.1
*                                            
*  Version:     1.0                                                         
*                                                                                                                                                         
*  Author:      Santiago Lopez [SL](SSE Americas)
*              
*                                                                                     
*  Location:    Guadalajara,Mexico                                              
*                                                                                                                  
*                                                  
* UPDATED HISTORY:
*
* REV   YYYY.MM.DD  AUTHOR   DESCRIPTION OF CHANGE
* ---   ----------  ------   --------------------- 
* 1.0   2010.11.22    SL        Initial version
* 
******************************************************************************/                                                                        
/* Freescale  is  not  obligated  to  provide  any  support, upgrades or new */
/* releases  of  the Software. Freescale may make changes to the Software at */
/* any time, without any obligation to notify or provide updated versions of */
/* the  Software  to you. Freescale expressly disclaims any warranty for the */
/* Software.  The  Software is provided as is, without warranty of any kind, */
/* either  express  or  implied,  including, without limitation, the implied */
/* warranties  of  merchantability,  fitness  for  a  particular purpose, or */
/* non-infringement.  You  assume  the entire risk arising out of the use or */
/* performance of the Software, or any systems you design using the software */
/* (if  any).  Nothing  may  be construed as a warranty or representation by */
/* Freescale  that  the  Software  or  any derivative work developed with or */
/* incorporating  the  Software  will  be  free  from  infringement  of  the */
/* intellectual property rights of third parties. In no event will Freescale */
/* be  liable,  whether in contract, tort, or otherwise, for any incidental, */
/* special,  indirect, consequential or punitive damages, including, but not */
/* limited  to,  damages  for  any loss of use, loss of time, inconvenience, */
/* commercial loss, or lost profits, savings, or revenues to the full extent */
/* such  may be disclaimed by law. The Software is not fault tolerant and is */
/* not  designed,  manufactured  or  intended by Freescale for incorporation */
/* into  products intended for use or resale in on-line control equipment in */
/* hazardous, dangerous to life or potentially life-threatening environments */
/* requiring  fail-safe  performance,  such  as  in the operation of nuclear */
/* facilities,  aircraft  navigation  or  communication systems, air traffic */
/* control,  direct  life  support machines or weapons systems, in which the */
/* failure  of  products  could  lead  directly to death, personal injury or */
/* severe  physical  or  environmental  damage  (High  Risk Activities). You */
/* specifically  represent and warrant that you will not use the Software or */
/* any  derivative  work of the Software for High Risk Activities.           */
/* Freescale  and the Freescale logos are registered trademarks of Freescale */
/* Semiconductor Inc.                                                        */ 
/*****************************************************************************/

#ifndef _ButtonsHandler_H_
#define _ButtonsHandler_H_

/*****************************************************************************/
/*                                Includes
/*****************************************************************************/

 #include "FslTypes.h"
 #include "derivative.h"
  
/*****************************************************************************/
/*                               Definitions
/*****************************************************************************/

 #define PUSH_BUTTONS_ENABLED         //Enable push button control
 
  
/*****************************************************************************/
/*                          Typedefs and Structs
/*****************************************************************************/

 typedef enum
 {
  BUTTON_IDDLE,
  BUTTON_EXIT,
  BUTTON_SELECT,
  BUTTON_UP,
  BUTTON_DOWN,
  BUTTON_LEFT,
  BUTTON_RIGHT
 }BUTTON_STATUS; 

/*****************************************************************************/
/*                                 Globals
/*****************************************************************************/

 extern UINT8 gu8ButtonStatus;

/*****************************************************************************/
/*                           Functions Definition
/*****************************************************************************/

 void vfnButtons_Init (void);
 
 void vfnKBI1_ISR(void);
 
 void vfnKBI2_ISR(void);

#endif